<?php
include("templates/headers/inc.php");

// Include the JS file
$js_files = array("js/pages/quiz.js");

// Metadata informations of this page
$page_slug	= "quiz";

if(!isset($_GET["id"])) {
	header("Location: index.php?error=no_param");
	exit;
}

// Get website config
$site_config = $dbh->prepare("SELECT * FROM config WHERE config_name IN ('website_name','website_tagline','ads_code','allow_fb')");
$site_config->execute();

$config_array = array();

while($config = $site_config->fetch(PDO::FETCH_ASSOC)) {
	$config_array[$config["config_name"]] = $config["config_value"];
}

$website_name = $config_array["website_name"];
$website_tagline = $config_array["website_tagline"];
$ads_code = $config_array["ads_code"];
$allow_fb = $config_array["allow_fb"];

$nb_questions = 0;

$quiz_id = $_GET["id"];

// Check if user exists...
$quiz_sql = $dbh->prepare("	SELECT *
							FROM quiz
							WHERE unique_id = :quiz_id
							");
					
$quiz_sql->bindParam(':quiz_id', $quiz_id);
$quiz_sql->execute();

if($quiz_sql->rowCount() == 0) {
	header("Location: index.php?error=quiz_not_found");
	exit;
}

$fb_enabled = false;

if(FB_APP_ID != "" && FB_APP_SECRET != "") {

	// Initialize FB SDK
	$fb = new \Facebook\Facebook([
		'app_id' => FB_APP_ID,
		'app_secret' => FB_APP_SECRET,
		'default_graph_version' => 'v2.3'
	]);	
	
	$helper = $fb->getRedirectLoginHelper();
	
	// Get FB Login URL
	$permissions = ['email']; // Optional permissions
	$loginUrl = $helper->getLoginUrl(URL . "/fb-login.php", $permissions);

	$fb_enabled = true;

}

$quiz = $quiz_sql->fetch(); 

$quiz_author = $quiz["user_id"];

// Get infos about the author of the quiz...
$author_sql = $dbh->prepare("	SELECT *
								FROM user
								WHERE id = :user_id
							");
					
$author_sql->bindParam(':user_id', $quiz_author);
$author_sql->execute();

if($author_sql->rowCount() == 0) {
	header("Location: index.php?error=author_not_found");
	exit;
}

$author = $author_sql->fetch();

$q_id = $quiz["id"];

$page_title = "Quiz about " . $author["fullname"];

// -- Include the header template
include("templates/headers/quiz_header.php");
?>

<?php
if($ads_code != "") {
?>
<div class="row">
	<div class="col-md-12">
		<?php
		echo $ads_code;
		?>
	</div>
</div>
<?php
}	
?>
					
<div class="row">
	
	<div class="inner-container content">
		
		<div class="author_profile_infos">
			<div class="author_profile_pic">
				
				<img src="<?php echo $author["profile_picture"]; ?>" alt="" />
				
			</div>
			<h4>Quiz about <b><?php echo htmlspecialchars($author["fullname"]); ?></b></h4>
			
			<hr />
		</div>
		<div class="quiz_container">
			<div class="quiz_inner">
				<div class="take_quiz_container">
					<?php
					if($_SESSION && isset($_SESSION["USER_ID"])) {
						
						if($author["id"] == $_SESSION["USER_ID"]) {
							?>
							<div class="alert alert-danger alert-center">
								Oops... You can't take a quiz about yourself. Share it with your friends instead <i class="em em-wink"></i>
							</div>
							<div class="input-group">
								<input type="text" id="quiz-link" class="form-control" readonly value="<?php echo URL; ?>/quiz.php?id=<?php echo $quiz_id; ?>" />
								<div class="input-group-append">
									<button class="btn btn-primary btn-copy" data-clipboard-target="#quiz-link" type="button" id="button-addon2">Copy</button>
									</div>
							</div>
							<small><i class="fas fa-info-circle"></i> Copy this link and share it with your friends so they can do it!</small>
							<hr />
							<div id="share"></div>
							<?php
						} else {
					?>
					Welcome <b><?php echo htmlspecialchars($_SESSION["FULL_NAME"]); ?></b>, you can now take this quiz <i class="em em-smiley"></i>
					<br>
					<a href="" class="btn btn-primary btn-lg btn-play-quiz"><i class="fas fa-play"></i> Take this Quiz</a>
					<?php
						}
					} else {
					?>
					<div class="quiz_login_container">
						
						<h4>Login with Facebook to Take the Quiz</h4>
						<?php
						if($allow_fb == 1 && $fb_enabled) {
						?>
						<a href="<?php echo $loginUrl; ?>" class="btn-login-fb"><img src="<?php echo URL; ?>/img/fb-login.png" alt="Login with Facebook" /></a>
						<div class="or_separator">
				        	OR
				        </div>
				        <a href="sign-up.php" class="btn btn-primary btn-sign-up">Create an Account with an Email</a>
				        <?php
						}
						?>
						<small><i class="fas fa-info-circle"></i> We are only asking you to login with Facebook so <b><?php echo $author["fullname"]; ?></b> knows who is taking the quiz <i class="em em-wink"></i></small>
						
						
					</div>
					<?php									
					}
					?>
				</div>
				
				
				<?php
				if($_SESSION && isset($_SESSION["USER_ID"])) {
				?>
				<div class="quiz_questions_container">
					
					<form action="" method="POST" id="quiz-form">
						<?php
						// Get the questions for this quiz
						$questions_query = $dbh->prepare("SELECT * FROM question WHERE quiz_id = :quiz_id");
						$questions_query->bindParam(":quiz_id", $q_id);
						$questions_query->execute();
						
						$count = 1;
						$nb_questions = $questions_query->rowCount();
						
						while ($question = $questions_query->fetch(PDO::FETCH_ASSOC)) {
							
							$question_id = $question["id"];
							
							?>
							<div class="quiz_q_container <?php if($count == 1): ?>current<?php endif; ?>" data-id="<?php echo $question_id; ?>" data-count="<?php echo $count; ?>">
								
								<div class="col-md-6 offset-md-3">
									<div class="quiz_q_question"><?php echo htmlspecialchars($question["question"]); ?></div>
									
									<div class="quiz_q_answers">
										
										<?php
										// Get answers list for this question
										$answers_query = $dbh->prepare("SELECT * FROM question_answers WHERE question_id = :question_id");
										$answers_query->bindParam(":question_id", $question_id);
										$answers_query->execute();
										
										while($answer = $answers_query->fetch(PDO::FETCH_ASSOC)) {
										?>
										
										<div class="quiz_q_answer" data-id="<?php echo $answer["id"]; ?>">
											<label class="custom-control fill-checkbox">
												<input type="checkbox" class="fill-control-input">
												<span class="fill-control-indicator"></span>
												<span class="fill-control-description"><?php echo htmlspecialchars($answer["answer"]); ?></span>
											</label>
										</div>
										<?php
										}	
										?>
										
										<div class="btns-container">
											
											<?php
											if($count > 1) {
											?>
											<a class="btn btn-sm btn-primary btn-prev-question" href="#"><i class="fas fa-angle-left"></i> Prev</a>
											<?php
											}
											?>
											
											<?php
											if($count == $nb_questions)	{
											?>
											<a class="btn btn-sm btn-success btn-finish-quiz" href="#"><i class="fas fa-check"></i> Finish Quiz</a>
											<?php 
											} else {
											?>
											<a class="btn btn-sm btn-primary btn-next-question" href="#">Next <i class="fas fa-angle-right"></i></a>
											<?php
											}
											?>
										</div>
									</div>
								</div>
							</div>
							<?php
							$count++;
						}
						?>
					</form>
													
				</div>
				<?php
				}
				?>
			</div>
			
			<div class="quiz_success_container">
				
				<div class="percent_container">
					
				</div>
				<div class="percent_line">
					You got <span class="good_replies_count"></span> good and <span class="wrong_replies_count"></span> wrong answers about <b><?php echo $author["fullname"]; ?></b>
				</div>
				<hr />
				Share your results with your friends :
				<div id="share2"></div>
				
			</div>
			
		</div>
		
	</div>
	
</div>



<script type="text/javascript">
	
	var unique_id = "<?php echo $quiz_id; ?>";
	var nb_questions = <?php echo $nb_questions; ?>;
	var url = "<?php echo URL; ?>";
	var current_quiz_id = "<?php echo $quiz_id; ?>";
		
</script>
<?php
// -- Include the footer template
include("templates/footers/global_footer.php");	
?>